import Mapper

# TAGS INDICATE IDENTIAL SHEETS
# NUMBERS are completely unconstrained
# LETTERS enforce internal symmetry
# < indicates a tile, with the arrow pointed in direction of polarization and feed
# X indicates an empty gap
# || or = (double lines) imply mirror symmetry on either side

#  |----------------------------------------------|
#  |  < |  1 |  < |  2 ||  < ||  2 |  < |  1 |  < |
#  |----------------------------------------------|
#  |  3 |  X |  4 |  X ||  A ||  X |  4 |  X |  3 |
#  |----------------------------------------------|
#  |  < |  5 |  < |  6 ||  < ||  6 |  < |  5 |  < |
#  |----------------------------------------------|
#  |  7 |  X |  8 |  X ||  B ||  X |  8 |  X |  7 |
#  |==============================================|
#  |  < |  C |  < |  D ||  < ||  D |  < |  C |  < |
#  |==============================================|
#  |  7 |  X |  8 |  X ||  B ||  X |  8 |  X |  7 |
#  |----------------------------------------------|
#  |  < |  5 |  < |  6 ||  < ||  6 |  < |  5 |  < |
#  |----------------------------------------------|
#  |  3 |  X |  4 |  X ||  A ||  X |  4 |  X |  3 |
#  |----------------------------------------------|
#  |  < |  1 |  < |  2 ||  < ||  2 |  < |  1 |  < |
#  |----------------------------------------------|

#           Symmetric about the E and H plane axis
#              TOTAL NUMBER OF BITS = 248

# maps the switch states so that the array is symetric about the E plane
# bit ordeer is left to right, top to bottom by switch and then by sheet
class EandHPlaneMirror(Mapper.Mapper):
    # intializes the mapper
    # index map is a dictionary
    # return type: self
    def __init__(self):
        indexMap = {}
        bit_idx = 0
        # assign top left quadrant of array new bits
        for sheet_y in range(4,0,-1):
            for sheet_x in range(-4,0,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = bit_idx
                                bit_idx += 1
        # assign left half of center colomn (top array half) of sheets new bits
        for sheet_y in range(4,0,-1):
            for sheet_x in [0]:
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,1,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = bit_idx
                                bit_idx += 1
        # assign top half of center row (left array half)  of sheets new bits
        for sheet_y in [0]:
            for sheet_x in range(-4,0,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-1,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = bit_idx
                                bit_idx += 1

        # assign bottom half of center row (left array half) of sheets mirrored bits
        for sheet_y in [0]:
            for sheet_x in range(-4,0,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(-1,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                mirror_coordinates = (sheet_x,sheet_y,switch_x,-1*switch_y)
                                bit_loc = indexMap[mirror_coordinates]
                                indexMap[coordinates] = bit_loc

        # assign right half of center colomn (top array half) of sheets mirrored bits
        for sheet_y in range(4,0,-1):
            for sheet_x in [0]:
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(1,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                mirror_coordinates = (sheet_x,sheet_y,-1*switch_x,switch_y)
                                bit_loc = indexMap[mirror_coordinates]
                                indexMap[coordinates] = bit_loc


        # assign bottom left quadrant (included center column) mirrored bits
        for sheet_y in range(-1,-5,-1):
            for sheet_x in range(-4,1,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                mirror_coordinates = (sheet_x,-1*sheet_y,switch_x,-1*switch_y)
                                bit_loc = indexMap[mirror_coordinates]
                                indexMap[coordinates] = bit_loc

        # assign right half of array (excluding center column) mirrored bits
        for sheet_y in range(4,-5,-1):
            for sheet_x in range(1,5,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                mirror_coordinates = (-1*sheet_x,sheet_y,-1*switch_x,switch_y)
                                bit_loc = indexMap[mirror_coordinates]
                                indexMap[coordinates] = bit_loc

        # assign unused sheets to same bit (BIT 0)
        for sheet_y in [-5]:
            for sheet_x in range(-4,6):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4,1):
                        for switch_y in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = 0
        for sheet_y in range(-4,6):
            for sheet_x in [-5]:
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4,1):
                        for switch_y in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = 0
        super(EandHPlaneMirror,self).__init__(248,indexMap)
